/* ROBERT CHRISTOPHERSON    415-697-9136                                  */
/* 11-20-91                                                               */
/* Fluke                    sun3_util    (use on Sun3x systems)           */
/* Microsoft C              SUN 3 System                                  */

/* ********************* Program Description **************************** */
/*                                                                        */
/*  This program takes a Fluke file created by the copy command and sent  */
/*  by terminal emulation.  This program reads the header and             */
/*  copies each separate file back to the disk.                           */
/*  This file provides the Main Menu to select file download,conversion   */
/*  from one large file to original individual Fluke files, etc.          */
/*                                                                        */
/* ********************** Include Files    ****************************** */
/* -- DOS Includes ------- */
#include <math.h>

/* -- DOS & Sun Includes - */
#include <string.h>
/* #include <stdlib.h> */
/* #include <stdio.h>  */
#include <ctype.h>

/* -- Sun Includes ------- */
#include <sys/types.h>
#include <sys/stat.h>
#include <curses.h>
#include <time.h>
#include <signal.h>
#include <sys/termios.h>
#include <sys/fcntl.h>

/* #include <floatingpoint.h>            -- ? to decimal conversions ----- */


/* -- DOS Only Includes -- */
#include <malloc.h>
/* #include <conio.h>      */
/* #include <dos.h>        */
/* #include <prtdef.h>     */

/* #include <process.h>    */
/* #include <errno.h>      */

/* ************************ Constants *********************************** */
#define DEBUG  0                           /* enable to display info      */
#define TRUE   0
#define FALSE  1
#define AUTO 1
#define SELECT 2
#define CUR_REV 3
#define TEMP2 4
#define SINGLE_FILE 5

/* ******************* External Variables  *****************************  */

/* *****************   Function Prototypes *****************************  */

void input_file(); /* inputs file from disk drive (same dir) */
void print_title();             /* Displays menu heading                  */
void getxy();          /* Find current cursor location           */
void setc();             /* Reset cursor location to prev. location*/
void clearsrn();                /* Uses linefeed to clear screen          */
void keyflush();                /* Empty keyboard buffer                  */

/*------------------------------------------------------------------------*/
/*                     Begin Program                                      */
/*------------------------------------------------------------------------*/

int main(argc,argv)
  int argc;                  /* -- argc,*argv required by spawn call       */
  char *argv[];              /* -- from Main Menu program                  */

  {                         /* --- Begin Main  ------------------------ */

   char in_name[25], out_name[25];  /* ---- for disk file input ------- */
   FILE *in_file,*out_file,*fopen();
   int i, counter;
   int column,row;                  /* -- screen row/column locations - */
   int col,r;                       /* -- temporary row/column locations*/
   int temp;
   int finish;                      /* -- flag - finished inputting # - */
   char ch[10];                     /* -- character input               */
   char buffer[81];
   char *args[4];                    /* -- used by spawn call          - */
   buffer[5] = '\0';

   /* ************   Setup the screen    ****************************** */
   keyflush();                      /* -- clear key buffers      ------ */
 /*  clear();                */     /* -- DOS Call to clear screen  --- */
 /*  setc(0,0);              */     /* -- Set cursor to top of screen - */
   print_title();                   /* -- prints heading       -------- */

/*   getxy(&row,&column);  */       /* -- Locate original location  --- */

   /* **************   Enter The Selection   *************************** */
   finish = 0;
  do                                  /* Loop until 1,2 or 3 is selected */
   {
   gets(ch);
   switch(atoi(ch))
    {
     case 1:                  /* from RS232 port to Archive Directories   */
        auto_port(AUTO);
        print_title();
        break;
     case 2:
        auto_port(CUR_REV);  /* RS232 port to fluke/current_rev/selection */
        print_title();               /* -- prints heading       --------- */
        break;
     case 3:
        auto_port(SELECT);   /* from RS232 port to selected Directory     */
        print_title();
        break;
     case 4:
        auto_port(SINGLE_FILE);  /* ignore headings   -----------------  */
        print_title();
        break;
     case 5:
        printf("Program not Available yet\n");
        break;
     case 6:
        printf("Program not Available yet\n");
        break;
     case 7:
        printf("Program not Available yet\n");
        break;
     case 8:
        helpmenu();
        print_title();
        continue;
     case 9:                              /* quit the program            */
        printf("\n\nProgram Terminated\n\n\n");
        finish = 1;
        break;
     default:                             /* wrong selection             */
        printf("   The incorrect number was entered, enter 1,2,3 etc.\n");
        printf("   Enter the Number: ");
        break;
    }                                 /* **** end switch(atoi(ch))  **** */

   }while (!finish);                  /* end enter char loop          ** */


   exit(0);
   }                   /* -------------  End of Main Program   --------- */


/* ********************************************************************** */
/*                    Begin Subroutines                                   */
/* ********************************************************************** */

    /* --------- input_file - Begin Disk File Input  ---------------------*/

void input_file(string,filename)                        /* ** FUNCTION ** */
   char string[];
   char filename[];
   {
   return;
   }

/* *************  print_title() - print heading   ********************** */
void print_title()                                     /* ** FUNCTION ** */
   {
   printf("\n\n");
   printf("      **************************************************************\n");
   printf("      *              FLUKE FILE CONVERSION UTILITIES               *\n");
   printf("      *              REV. 4    SUN VERSION      1992               *\n");
   printf("      **************************************************************\n");
   printf("\n\n");
   printf("  SELECT THE OPERATION (1 - 9) AND PRESS ENTER:\n\n");
   printf(" [1] - Backup from RS232 port to Sun Directory (Automated)\n");
   printf(" [2] - Backup from RS232 port to Sun (Select Directory in /Current_Rev)\n");
   printf(" [3] - Backup from RS232 port to Sun Directory (Select complete Directory)\n");
   printf(" [4] - Backup a Single TEXT File (Any name!)\n");
   printf(" [5] - For Future Use\n");
   printf(" [6] - For Future Use\n");
   printf(" [7] - For Future Use\n");
   printf(" [8] - HELP\n");
   printf(" [9] - Quit the Program \n");
   printf("\n\n     * Enter the Number: ");

   return;
   }

/* **************  find current row/column location   ******************* */
void getxy(pr,pc)                                       /* ** FUNCTION ** */
   int *pr, *pc;                           /* ** Originally a DOS Call ** */
   {
    int r,c;
/*    getyx(stdscr,r,c)    */
/*    *pr = r;             */
/*    *pc = c;             */

    return;
   }

/* *******************  set row/column location   ********************** */
void setc(c,r)                                         /* ** FUNCTION ** */
   int c,r;                                            /* ** DOS Call ** */
   {
/*    move(r,c);   */
    return;
   }

/* ******************* Clear The Screen  ******************************* */
void clearsrn()               /* --- linefeeds to clear the screen  ---- */
   {                                                   /* ** FUNCTION ** */
   int i=0;
   for (i=0;i <= 40;i++)
         printf("\n");
   return;
   }

/* *********** ******** Clear Keyboard Buffer  ************************** */
void keyflush()                                        /* ** FUNCTION ** */
   {
 /*   while (kbhit() != 0)      */
 /*     {                       */
 /*      getch();               */
 /*     }                       */
    return;
   }

/**************************************************************************/
/*                    END OF FILE                                         */
/**************************************************************************/

